﻿using System;
using System.Threading;
using System.Text;

// Listing 16.4. Zmienne lokalne, lecz wspólny stan.

class Program
{
    static void Main(string[] args)
    {
        StringBuilder result = new StringBuilder();

        // Współużytkowanie obiektu StringBuilder w kilku wątkach. BŁĄD!
        Thread t1 = new Thread(() => Go(result, "Pierwszy"));
        Thread t2 = new Thread(() => Go(result, "Drugi"));

        t1.Start();
        t2.Start();

        Go(result, "Wątek główny");

        t1.Join();
        t2.Join();

        Console.WriteLine(result);
    }

    static void Go(StringBuilder sb, string name)
    {
        for (int i = 0; i < 100; ++i)
        {
            // Wszystkie wątki używają tego samego obiektu StringBuilder...
            // TO ZŁY POMYSŁ!
            sb.AppendFormat("{0}: {1}", name, i);
            sb.AppendLine();
        }
    }
}